function JCheckGroup(owner, parent, name, caption, dataset, field, paintCaption, paintRect, rect, columns, tab)
{
    var self = this,
	_disposed = false,
	_field = null,
	_itemHeight = 18,
	_paintCaption = utils.parseBool(paintCaption),
	_paintRect = utils.parseBool(paintRect);

	this.initialize(owner, parent, name, caption, null, rect, null, field, dataset, tab);

	this.methods = (cmRender | cmLoad);

	this.columns = parseInt(columns);
	
	this.render = render;
	this.load   = load;
	this.dispose = dispose;
	this.select = select;
	this.bind_setValue = bind_setValue;
	

	function render(fs)
	{
		if (self.isInvisible())
			return;

		_field = self.dataset.fields[self.field];  

		var addClass = '';
/*
		if (self.isInvisible())
		{
			addClass += ' invisible';
		}
*/
		
		var border = (_paintRect) ? '' : ';border-width: 0'

		if ((!browser.isIE) && (_paintRect))
		{
			self.rect.width -= 4; //  border + padding;
			self.rect.height -= 4;
		}

		fs.append('<fieldset class="' + addClass +'" style="position: absolute; ' + self.rect + border + '">');
		if (_paintCaption)
			fs.append('<legend>' + self.caption + '</legend>');
		fs.append('<div>');

		var topMargin = _paintCaption ? 14 : 0;
		var buttonsCount = _field.getItemCount();
		var buttonsPerCol = Math.floor((buttonsCount + this.columns - 1) / this.columns);
		var buttonWidth = Math.floor((self.rect.width - 10) / this.columns);
		var buttonHeight = Math.floor((self.rect.height - topMargin) / buttonsPerCol);
		var descWidth = buttonWidth - 21; //21 = input width;
		var descTopMargin = browser.isIE ? 3 : 6;
		var buttonStyle = 'display:block;white-space: nowrap;float:left;overflow: hidden;text-overflow:ellipsis;margin-top:' + descTopMargin + 'px;max-width:' + descWidth + 'px;;width:' + descWidth + 'px';

		var i = 0;
		_field.items.forIn(function (item, name) {
		    var left = (Math.floor(i / buttonsPerCol)) * buttonWidth;
		    var top = (i % buttonsPerCol) * buttonHeight + topMargin;
		    fs.append('<span style="position: absolute; height: ' + buttonHeight + '; width: ' + buttonWidth + '; top: ' + top + '; left: ' + left + ';"><input style="float:left" id="' + self.name + '_item_' + name + '" type="checkbox" _itemId="' + name + '"/><span style="' + buttonStyle + '">' + item + '</span></span>');
		    i++;
		}, self);

		fs.append('</div></fieldset>');
	}

	function load()
	{
		if (self.isInvisible())
			return;

		_field.items.forIn( function (item, i)
		{
			self.$$('_item_' + i).onclick = getClickFunc(i);
		}, self);

		setChecked();

		dataset.bindingManager.bind(self, '', self.field);
	}

	function setChecked()
	{
		var value = self.dataset.get(self.field);
		_field.items.forIn( function (item, i)
		{
			self.$$('_item_' + i).checked = (value & i);
		}, self);
	}

	function getClickFunc(idx)
	{
		return function() { self.select(idx); };
	}

	function select(idx)
	{
		var value = self.dataset.get(self.field);

		if (idx != null)
		{
			if (value == null)
				value = 0;

			value ^= idx;
		}
		else
		{
			value = 0;
		}

		self.dataset.set(self.field, value);
	}

	function bind_setValue(prop, field, record)
	{
		setChecked();
	} 

	function dispose()
	{
		if (_disposed)
			return;

		_field.items.forIn( function (item, i)
		{
			self.$$('_item_' + i).onclick = null;
		}, self);

		if ((self.dataset != null) && (self.dataset.bindingManager != null))
			self.dataset.bindingManager.unbind(self);

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JCheckGroup.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();